/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific.forge.networking;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;

public class Dim_Confirm {
    private ResourceKey<Level> dimensionType;
    private Vec3 pos;

    public Dim_Confirm(ResourceKey<Level> dimensionType, Vec3 pos) {
        this.dimensionType = dimensionType;
        this.pos = pos;
    }

    public Dim_Confirm(FriendlyByteBuf buf) {
        this.dimensionType = DimId.readWorldId(buf, true);
        this.pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(FriendlyByteBuf buf) {
        DimId.writeWorldId(buf, this.dimensionType, false);
        buf.writeDouble(this.pos.f_82479_);
        buf.writeDouble(this.pos.f_82480_);
        buf.writeDouble(this.pos.f_82481_);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> MiscHelper.executeOnRenderThread(() -> ClientTeleportationManager.acceptSynchronizationDataFromServer(this.dimensionType, this.pos, false)));
        ctx.setPacketHandled(true);
        return true;
    }
}

